#!/bin/sh

# include environment variables
. /etc/profile.d/product.sh

# environment variable
PATH="${PATH}:/usr/local/sbin:/sbin"


# [workaround] To prevent from vSphere CLI error - Server version unavailable in some environment.
export PERL_LWP_SSL_VERIFY_HOSTNAME=0
export TERM=rxvt
export LANG=C
export LC_ALL=en_US.UTF-8


########################################
# constants
########################################
CONS_TUI_DIR="/opt/TrendMicro/Pixiebob/textUI/"
CONS_EULA_FILE="${CONS_TUI_DIR}eula.txt"
CONS_MS_INSTALL_PATH="/opt/TrendMicro/DTAS/ManagementServer/"
DTASCFG_XML_FILE="/etc/dtascfg.xml"
IPV4_ADDR=`ip -f inet -o addr show eth0 | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g'`
[ "${IPV4_ADDR}" = "" ] && IPV4_ADDR="-"
IPV6_ADDR=`ip -f inet6 -o addr show eth0 | grep -v 'local' | grep -v 'dynamic' | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g' | tr '[a-z]' '[A-Z]'`
[ "${IPV6_ADDR}" = "" ] && IPV6_ADDR="-"
CONS_BACK_TITLE="Trend Micro Deep Discovery Director $(cat /opt/TrendMicro/Pixiebob/version.txt)"
CONS_BACKEND="${CONS_TUI_DIR}backend.php"
CONS_DEPLOYMENT_STATUS_FILE="/dev/shm/deployment_status.txt"
CONS_IP_ADDR="(IPv4: ${IPV4_ADDR} | IPv6: ${IPV6_ADDR})"
CONS_IP_ADDR_V4="IPv4: ${IPV4_ADDR}"
CONS_IP_ADDR_V6="IPv6: ${IPV6_ADDR}"
CONS_HOST_NAME="Host name: `hostname`"

CONS_BOX_HEIGHT=20
CONS_BOX_WIDTH=75
CONS_BOX_ERROR_HEIGHT=20
CONS_BOX_ERROR_WIDTH=75

BACK_TITLE="${CONS_BACK_TITLE}"
BACKEND="${CONS_BACKEND}"
box_height=${CONS_BOX_HEIGHT}
box_width=${CONS_BOX_WIDTH}
MS_INSTALL_PATH="${CONS_MS_INSTALL_PATH}"

########################################
# Runtime variable
########################################
RT_MASTER_MODE=""
RT_DEPLOY_STATUS=""

RT_MS_DHCP=""
RT_MS_IP=""
RT_MS_NETMASK=""
RT_MS_GATEWAY=""
RT_MS_DNS=""
RT_MS_DNS2=""

RT_SC_DHCP=""
RT_SC_IP=""
RT_SC_NETMASK=""
RT_SC_GATEWAY=""
RT_SC_DNS=""
RT_SC_IMAGE_PATH=""
RT_SC_IMAGE_PATH_ESXI=""

RT_SB_IMAGE_PATH=""
RT_SB_IMAGE_PATH_ESXI=""
RT_SB_IMAGE_PATH_VIX=""
RT_SB_NUMBER=""

RT_NAT_INTERNET_CONN=""
RT_NAT_DHCP=""
RT_NAT_IP=""
RT_NAT_NETMASK=""
RT_NAT_GATEWAY=""
RT_NAT_DNS=""

RT_ESXI_IP=""
RT_ESXI_USERNAME=""
RT_ESXI_PASSWORD=""
RT_ESXI_SERVICE_SSHD_STATUS=""

RT_DEPLOYMENT_PERCENTAGE=""
RT_DEPLOYMENT_PROGRESS_STATUS=""

########################################
# include outer source
########################################
cd "${CONS_TUI_DIR}"
. ./constants.sh
. ./strings.sh
. ./utility.sh
. ./common.sh

# dialog templates
. ./tp_dhcp_or_static.sh
. ./tp_network_conf.sh
. ./tp_menu_ok.sh
. ./tp_menu_ok_cancel.sh
. ./tp_msg_ok.sh
. ./tp_checklist_ok_cancel.sh
. ./tp_radiolist.sh
. ./tp_form.sh
. ./tp_mixedform.sh
. ./tp_inputbox.sh
. ./pages_roller.sh
. ./tp_ping.sh
. ./tp_yesno.sh
#. /opt/TrendMicro/DTAS/cluster/utility/ddan_ha_utils.sh


########################################
# supporting functions
########################################

init() {
    trap 'exit 1' SIGINT
    
    #audit log
    # save_audit_log "all.systemEvents.textui.login" "600"
    
    #debug_print 'loading configuration from /etc/dtascfg.xml'
    #utility_load_conf

    #debug_print 'calling "check_create_api_key" without ARGV'
    #check_create_api_key
	
	#debug_print 'calling "check_create_server_uuid" without ARGV'
	#check_create_server_uuid

    setterm -powersave off -blank 0 >/dev/null 2>&1
}

enter_master_mode() {

    #debug_print "${0}" "${LINENO}" 'in function "enter_master_mode"'
	# constans
	MASTER_MODE_RESULT_OK=0
	MASTER_MODE_RESULT_ERROR=1
	MASTER_MODE_RESULT_CODE="${MASTER_MODE_RESULT_ERROR}"
	
	# include pages
	. ./master_page_main_settings.sh
	. ./master_page_ms_network_conf.sh
        . ./master_page_data_network_conf.sh
	. ./master_page_ping.sh
	. ./master_page_ms_change_password.sh
	. ./master_page_ms_new_password.sh
        . ./master_page_accounts_mngt.sh
	. ./master_page_ha.sh
        . ./master_page_new_account_name.sh
        . ./master_page_account_conf.sh
        . ./master_page_sshd_enable.sh
	
	local master_pages_array="master_page_main_settings"
	pages_roller "${master_pages_array}"
	
    case "${PAGES_ROLLER_RESULT_CODE}" in
    
        "${PAGES_ROLLER_RESULT_OK}" )
            MASTER_MODE_RESULT_CODE="${MASTER_MODE_RESULT_OK}"
            ;;
            
        "${PAGES_ROLLER_RESULT_ERROR}" )
            MASTER_MODE_RESULT_CODE="${MASTER_MODE_RESULT_ERROR}"
            ;;
            
        * )
            ;;
    esac
}

########################################
# Main
########################################

init
log_tag="ecli"
#load_common_config
while true
do
	enter_master_mode
	if [ "${MASTER_MODE_RESULT_CODE}" != "${MASTER_MODE_RESULT_OK}" ]; then
		exit 1
	fi
done
